/*
 * Decompiled with CFR 0.152.
 */
package org.sonarlint.eclipse.core.configurator;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.sonarlint.eclipse.core.configurator.ProjectConfigurationRequest;
import org.sonarlint.eclipse.core.internal.resources.ResourceUtils;
import org.sonarlint.eclipse.core.internal.utils.StringUtils;

public abstract class ProjectConfigurator {
    public static final String SEPARATOR = ",";

    public abstract boolean canConfigure(IProject var1);

    public abstract void configure(ProjectConfigurationRequest var1, IProgressMonitor var2);

    public void analysisComplete(Map<String, String> analysisProperties, IProgressMonitor monitor) {
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected static String getAbsolutePath(IPath path) {
        IPath absolutePath = ResourceUtils.getAbsolutePath(path);
        return absolutePath != null ? absolutePath.toString() : null;
    }

    public static void appendProperty(Map<String, String> properties, String key, String value) {
        if (value == null) {
            return;
        }
        String newValue = properties.get(key);
        newValue = newValue != null ? String.valueOf(newValue) + SEPARATOR + value : value;
        properties.put(key, newValue);
    }

    protected String getRelativePath(IPath root, IPath path) {
        String relativePath;
        IPath absoluteRoot = ResourceUtils.getAbsolutePath(root);
        IPath absolutePath = ResourceUtils.getAbsolutePath(path);
        String string = relativePath = absolutePath != null ? absolutePath.makeRelativeTo(absoluteRoot).toOSString() : null;
        if ("".equals(relativePath)) {
            relativePath = ".";
        }
        return relativePath;
    }

    public static void setPropertyList(Map<String, String> properties, String key, Collection<String> values) {
        properties.put(key, StringUtils.joinSkipNull(values, SEPARATOR));
    }

    public static void appendPropertyList(Map<String, String> properties, String key, Collection<String> values) {
        ProjectConfigurator.appendProperty(properties, key, StringUtils.joinSkipNull(values, SEPARATOR));
    }
}

